//Simulation of FDMA (Frequency Division Multiplexing and Demultiplexing) Technique 
// OS-Windows 10
// Scilab 6.1.0
// Course Instructor Name: Dr. V. A. Sankar Ponnapalli
// Institute Name: ICFAI Foundation for Higher Education Hyderabad

clear; 
clc;
close;

disp("=== FDMA System Capacity Simulation ===");

// Total bandwidth B_t
B_t = input("Enter total system bandwidth B_t in Hz [1e6 – 25e6]: ");
while B_t < 1e6 | B_t > 25e6
    B_t = input("Invalid! Enter B_t between 1e6 and 25e6 Hz: ");
end

// Guard band per side
B_guard = input("Enter guard band on one side B_guard in Hz [1e4 – 5e5]: ");
while B_guard < 1e4 | B_guard > 5e5
    B_guard = input("Invalid! Enter B_guard between 1e4 and 5e5 Hz: ");
end

// Channel bandwidth B_c
B_c = input("Enter bandwidth per FDMA channel B_c in Hz [1e4 – 5e4]: ");
while B_c < 1e4 | B_c > 5e4
    B_c = input("Invalid! Enter B_c between 1e4 and 5e4 Hz: ");
end

//-----------------------------
// Calculation
//-----------------------------
if B_t <= 2*B_guard then
    error("Total bandwidth must be greater than twice the guard band.");
end

B_available = B_t - 2 * B_guard;
N_channels = floor(B_available / B_c);
B_used = N_channels * B_c;
B_unused = B_available - B_used;
efficiency = (B_used / B_t) * 100;

mprintf("Total Bandwidth (B_t): %.2f Hz\n", B_t);
mprintf("Guard Band per side (B_guard): %.2f Hz\n", B_guard);
mprintf("Channel Bandwidth (B_c): %.2f Hz\n", B_c);
mprintf("Available Bandwidth after guard bands: %.2f Hz\n", B_available);
mprintf("Number of FDMA Channels (N): %d\n", N_channels);
mprintf("Total Used Bandwidth: %.2f Hz\n", B_used);
mprintf("Unused Bandwidth: %.2f Hz\n", B_unused);
mprintf("Bandwidth Utilization Efficiency: %.2f %%\n", efficiency);

scf(0);
bar([1 2], [B_used B_unused], "stacked");
xt = [1, 2];
labels = ["Used Bandwidth", "Unused Bandwidth"];
for i = 1:2
    xstring(xt(i) - 0.1, 0, labels(i));
end
ylabel("Bandwidth (Hz)");
title("FDMA Bandwidth Utilization");

// Description of the Figure
// User Inputs:
// Enter total system bandwidth B_t in Hz [1e6 – 25e6]: 1e6
// Enter guard band on one side B_guard in Hz [1e4 – 5e5]: 1e4
// Enter bandwidth per FDMA channel B_c in Hz [1e4 – 5e4]: 1e4
// The figure titles "FDMA Bandwidth Utilization" shows how efficiently the bandwidth is utilized in an FDMA system given user-defined channel width and guard bands.
